/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class MerchantsDockhandEffect
extends OneShotEffect {
    MerchantsDockhandEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top X cards of your library. Put one of them into your hand and the rest on the bottom of your library in any order";
    }

    private MerchantsDockhandEffect(MerchantsDockhandEffect effect) {
        super((OneShotEffect)effect);
    }

    public MerchantsDockhandEffect copy() {
        return new MerchantsDockhandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
        target.withNotTarget(true);
        if (controller.chooseTarget(Outcome.DrawCard, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
            cards.remove(card);
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

