/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class MesmericFiendExileEffect
extends OneShotEffect {
    public MesmericFiendExileEffect() {
        super(Outcome.Exile);
        this.staticText = "target opponent reveals their hand and you choose a nonland card from it. Exile that card";
    }

    private MesmericFiendExileEffect(MesmericFiendExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MesmericFiendExileEffect copy() {
        return new MesmericFiendExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && opponent != null && sourcePermanent != null) {
            Card card;
            opponent.revealCards(sourcePermanent.getName(), opponent.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)new FilterNonlandCard("nonland card to exile"));
            if (controller.choose(Outcome.Exile, opponent.getHand(), target, source, game) && (card = opponent.getHand().get(target.getFirstTarget(), game)) != null) {
                UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                game.getState().setValue(source.getSourceId().toString() + source.getStackMomentSourceZCC(), (Object)exileId);
                controller.moveCardsToExile(card, source, game, true, exileId, sourcePermanent.getName());
            }
            return true;
        }
        return false;
    }
}

