/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MesmericOrbTriggeredAbility
extends TriggeredAbilityImpl {
    MesmericOrbTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MillCardsTargetEffect(1), false);
    }

    private MesmericOrbTriggeredAbility(MesmericOrbTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MesmericOrbTriggeredAbility copy() {
        return new MesmericOrbTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a permanent becomes untapped, that permanent's controller mills a card.";
    }
}

