/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.UnearthAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MeticulousExcavationEffect
extends OneShotEffect {
    MeticulousExcavationEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target permanent you control to its owner's hand. If it has unearth, instead exile it, then return that card to its owner's hand";
    }

    private MeticulousExcavationEffect(MeticulousExcavationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MeticulousExcavationEffect copy() {
        return new MeticulousExcavationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        if (!permanent.getAbilities(game).containsClass(UnearthAbility.class)) {
            return player.moveCards((Card)permanent, Zone.HAND, source, game);
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        return player.moveCards(game.getCard(permanent.getMainCard().getId()), Zone.HAND, source, game);
    }
}

