/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class MightOfTheWild
extends CardImpl {
    private static final FilterCreaturePermanent filterMode1 = new FilterCreaturePermanent("Creatures with power 3 or less");
    private static final FilterPermanent filterMode2 = new FilterPermanent("artifact or enchantment");

    public MightOfTheWild(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}{G}{W}");
        this.getSpellAbility().addEffect((Effect)new CantBlockAllEffect(filterMode1, Duration.EndOfTurn));
        Mode mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent(filterMode2));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES));
        this.getSpellAbility().addMode(mode);
    }

    private MightOfTheWild(MightOfTheWild card) {
        super((CardImpl)card);
    }

    public MightOfTheWild copy() {
        return new MightOfTheWild(this);
    }

    static {
        filterMode1.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 4));
        filterMode2.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

