/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MightformHarmonizerEffect
extends OneShotEffect {
    MightformHarmonizerEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power of target creature you control until end of turn";
    }

    private MightformHarmonizerEffect(MightformHarmonizerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MightformHarmonizerEffect copy() {
        return new MightformHarmonizerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || permanent.getPower().getValue() == 0) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(permanent.getPower().getValue(), 0).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

