/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class MightyServantOfLeukOWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> crewCount = new HashMap<MageObjectReference, Integer>();
    private final Map<MageObjectReference, Set<MageObjectReference>> crewMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    MightyServantOfLeukOWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent crewer;
        Permanent vehicle;
        switch (event.getType()) {
            case VEHICLE_CREWED: {
                vehicle = game.getPermanent(event.getTargetId());
                crewer = null;
                break;
            }
            case CREWED_VEHICLE: {
                vehicle = game.getPermanent(event.getSourceId());
                crewer = game.getPermanent(event.getTargetId());
                break;
            }
            default: {
                return;
            }
        }
        if (vehicle == null) {
            return;
        }
        if (crewer == null) {
            this.crewCount.compute(new MageObjectReference((MageObject)vehicle, game), CardUtil::setOrIncrementValue);
            return;
        }
        this.crewMap.computeIfAbsent(new MageObjectReference((MageObject)vehicle, game), x -> new HashSet()).add(new MageObjectReference((MageObject)crewer, game));
    }

    public void reset() {
        super.reset();
        this.crewCount.clear();
        this.crewMap.clear();
    }

    public static boolean checkVehicle(Ability source, Game game) {
        MightyServantOfLeukOWatcher watcher = (MightyServantOfLeukOWatcher)game.getState().getWatcher(MightyServantOfLeukOWatcher.class);
        MageObjectReference mor = new MageObjectReference((MageObject)game.getPermanent(source.getSourceId()), game);
        return watcher.crewCount.getOrDefault(mor, 0) < 2 && watcher.crewMap.getOrDefault(mor, Collections.emptySet()).size() == 2;
    }
}

