/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MijaeDjinnEffect
extends OneShotEffect {
    MijaeDjinnEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you lose the flip, remove {this} from combat and tap it";
    }

    private MijaeDjinnEffect(MijaeDjinnEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(source.getSourceId());
        if (controller != null && creature != null) {
            if (controller.flipCoin(source, game, true)) {
                return true;
            }
            creature.removeFromCombat(game);
            creature.tap(source, game);
            return true;
        }
        return false;
    }

    public MijaeDjinnEffect copy() {
        return new MijaeDjinnEffect(this);
    }
}

