/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MinasMorgulEffect
extends AddCardSubTypeTargetEffect {
    MinasMorgulEffect() {
        super(SubType.WRAITH, Duration.Custom);
        this.staticText = "For as long as that creature has a shadow counter on it, it's a Wraith in addition to its other types";
    }

    private MinasMorgulEffect(MinasMorgulEffect effect) {
        super((AddCardSubTypeTargetEffect)effect);
    }

    public MinasMorgulEffect copy() {
        return new MinasMorgulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null || creature.getCounters(game).getCount(CounterType.SHADOW) < 1) {
            this.discard();
            return false;
        }
        return super.apply(game, source);
    }
}

