/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class MindBombEffect
extends OneShotEffect {
    MindBombEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player may discard up to three cards. {this} deals damage to each player equal to 3 minus the number of cards they discarded this way";
    }

    private MindBombEffect(MindBombEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindBombEffect copy() {
        return new MindBombEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Cards cardsPlayer;
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        HashMap<UUID, Object> cardsToDiscard = new HashMap<UUID, Object>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            CardsImpl cards = new CardsImpl();
            TargetDiscard target = new TargetDiscard(0, 3, new FilterCard(), playerId);
            player.chooseTarget(Outcome.Discard, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            cardsPlayer = (Cards)cardsToDiscard.get(playerId);
            cardsToDiscard.put(playerId, player.discard(cardsPlayer, false, source, game));
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null || (cardsPlayer = (Cards)cardsToDiscard.get(playerId)) == null) continue;
            player.damage(3 - cardsPlayer.size(), source.getSourceId(), source, game);
        }
        return true;
    }
}

