/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MindbladeRenderTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    MindbladeRenderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1, true));
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(1).concatBy("and"));
        this.setTriggerPhrase("Whenever your opponents are dealt combat damage, if any of that damage was dealt by a Warrior, ");
    }

    private MindbladeRenderTriggeredAbility(MindbladeRenderTriggeredAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public MindbladeRenderTriggeredAbility copy() {
        return new MindbladeRenderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage() || !game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.WARRIOR, game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).isEmpty();
    }
}

