/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class MindblazeEffect
extends OneShotEffect {
    MindblazeEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose a nonland card name and a number greater than 0. Target player reveals their library. If that library contains exactly the chosen number of cards with the chosen name, {this} deals 8 damage to that player. Then that player shuffles";
    }

    private MindblazeEffect(MindblazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player playerControls = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || playerControls == null || sourceObject == null) {
            return false;
        }
        ChoiceImpl numberChoice = new ChoiceImpl(false);
        numberChoice.setMessage("Choose a number greater than 0");
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 1; i <= 4; ++i) {
            numbers.add(Integer.toString(i));
        }
        numberChoice.setChoices(numbers);
        String cardName = ChooseACardNameEffect.TypeOfName.NON_LAND_NAME.getChoice(playerControls, game, source, false);
        playerControls.choose(Outcome.Neutral, (Choice)numberChoice, game);
        game.informPlayers(sourceObject.getIdName() + " - Chosen number: [" + numberChoice.getChoice() + ']');
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)player.getLibrary().getCards(game));
        playerControls.revealCards("Library", (Cards)cards, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new NamePredicate(cardName));
        int count = Integer.parseInt(numberChoice.getChoice());
        if (player.getLibrary().count(filter, game) == count) {
            player.damage(8, source.getSourceId(), source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    public MindblazeEffect copy() {
        return new MindblazeEffect(this);
    }
}

