/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MindleechMassEffect
extends OneShotEffect {
    MindleechMassEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "look at that player's hand. If you do, you may cast a spell from among those cards without paying its mana cost";
    }

    private MindleechMassEffect(MindleechMassEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindleechMassEffect copy() {
        return new MindleechMassEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        controller.lookAtCards(opponent.getName(), opponent.getHand(), game);
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)opponent.getHand()), (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
    }
}

