/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class MindsAglowEffect
extends OneShotEffect {
    MindsAglowEffect() {
        super(Outcome.Detriment);
        this.staticText = "<i>Join forces</i> &mdash; Starting with you, each player may pay any amount of mana. Each player draws X cards, where X is the total amount of mana paid this way";
    }

    private MindsAglowEffect(MindsAglowEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindsAglowEffect copy() {
        return new MindsAglowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            int xSum = 0;
            xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Minds Aglow", (Player)controller, (Ability)source, (Game)game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (Objects.equals(playerId, controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Minds Aglow", (Player)player, (Ability)source, (Game)game);
            }
            if (xSum > 0) {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    player = game.getPlayer(playerId);
                    if (player == null) continue;
                    player.drawCards(xSum, source, game);
                }
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

