/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import mage.abilities.common.SpellCastOpponentTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class MindsDilationTriggeredAbility
extends SpellCastOpponentTriggeredAbility {
    MindsDilationTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, StaticFilters.FILTER_SPELL, optional);
    }

    private MindsDilationTriggeredAbility(MindsDilationTriggeredAbility ability) {
        super((SpellCastOpponentTriggeredAbility)ability);
    }

    public MindsDilationTriggeredAbility copy() {
        return new MindsDilationTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List spells;
        SpellsCastWatcher watcher;
        if (super.checkTrigger(event, game) && (watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)) != null && (spells = watcher.getSpellsCastThisTurn(event.getPlayerId())) != null && spells.size() == 1) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts their first spell each turn, that player exiles the top card of their library. If it's a nonland card, you may cast it without paying its mana cost.";
    }
}

