/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MindshriekerEffect
extends OneShotEffect {
    MindshriekerEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player mills a card. {this} gets +X/+X until end of turn, where X is the milled card's mana value";
    }

    private MindshriekerEffect(MindshriekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        int totalCMC = targetPlayer.millCards(1, source, game).getCards(game).stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        if (totalCMC > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(totalCMC, totalCMC, Duration.EndOfTurn), source);
        }
        return false;
    }

    public MindshriekerEffect copy() {
        return new MindshriekerEffect(this);
    }
}

