/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MindstormCrownWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MindstormCrownEffect
extends OneShotEffect {
    MindstormCrownEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if you had no cards in hand at the beginning of this turn. If you had a card in hand, {this} deals 1 damage to you";
    }

    private MindstormCrownEffect(MindstormCrownEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindstormCrownEffect copy() {
        return new MindstormCrownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null) {
            return false;
        }
        MindstormCrownWatcher watcher = (MindstormCrownWatcher)game.getState().getWatcher(MindstormCrownWatcher.class);
        if (watcher != null && watcher.getCardsInHandCount() == 0) {
            controller.drawCards(1, source, game);
        } else if (permanent != null) {
            controller.damage(1, permanent.getId(), source, game);
        }
        return true;
    }
}

