/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class MindswipeEffect
extends OneShotEffect {
    MindswipeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that spell's controller";
    }

    private MindswipeEffect(MindswipeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindswipeEffect copy() {
        return new MindswipeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Spell object = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
            if (object == null) {
                object = game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
            }
            if (object instanceof Spell) {
                Spell spell = object;
                Player spellController = game.getPlayer(spell.getControllerId());
                if (spellController != null) {
                    int damage = GetXValue.instance.calculate(game, source, (Effect)this);
                    spellController.damage(damage, source.getSourceId(), source, game);
                }
                return true;
            }
        }
        return false;
    }
}

