/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class MinionOfTheMightyEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("a Dragon creature card");

    MinionOfTheMightyEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a Dragon creature card from your hand onto the battlefield tapped and attacking";
    }

    private MinionOfTheMightyEffect(MinionOfTheMightyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinionOfTheMightyEffect copy() {
        return new MinionOfTheMightyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        TargetCardInHand target = new TargetCardInHand(filter);
        if (controller == null) {
            return false;
        }
        target.choose(this.outcome, controller.getId(), source.getSourceId(), source, game);
        Card card = controller.getHand().get(target.getFirstTarget(), game);
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            game.getCombat().addAttackingCreature(permanent.getId(), game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

