/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MinionOfTheWastesEffect
extends ReplacementEffectImpl {
    MinionOfTheWastesEffect() {
        super(Duration.EndOfGame, Outcome.LoseLife);
        this.staticText = "pay any amount of life";
    }

    private MinionOfTheWastesEffect(MinionOfTheWastesEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MinionOfTheWastesEffect copy() {
        return new MinionOfTheWastesEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || controller == null) {
            return false;
        }
        int payAmount = controller.getAmount(0, controller.getLife(), "Pay any amount of life", source, game);
        PayLifeCost cost = new PayLifeCost(payAmount);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        Card sourceCard = game.getCard(source.getSourceId());
        game.informPlayers((sourceCard != null ? sourceCard.getLogName() : "") + ": " + controller.getLogName() + " pays " + payAmount + " life");
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(payAmount, payAmount, Duration.WhileOnBattlefield), source);
        creature.addInfo("life paid", CardUtil.addToolTipMarkTags((String)("Life paid: " + payAmount)), game);
        this.discard();
        return false;
    }
}

