/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MinionReflectorEffect
extends OneShotEffect {
    MinionReflectorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of that creature, except it has haste and \"At the beginning of the end step, sacrifice this permanent.\"";
    }

    private MinionReflectorEffect(MinionReflectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinionReflectorEffect copy() {
        return new MinionReflectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            for (Permanent addedToken : effect.getAddedPermanents()) {
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)new BeginningOfEndStepTriggeredAbility(TargetController.ANY, (Effect)new SacrificeSourceEffect(), false), Duration.Custom);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken.getId()));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            }
            return true;
        }
        return false;
    }
}

