/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class MinnWilyIllusionistEffect
extends OneShotEffect {
    MinnWilyIllusionistEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a permanent card with mana value less than or equal to that creature's power from your hand onto the battlefield";
    }

    private MinnWilyIllusionistEffect(MinnWilyIllusionistEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinnWilyIllusionistEffect copy() {
        return new MinnWilyIllusionistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("creatureDied");
        if (player == null || permanent == null) {
            return false;
        }
        FilterPermanentCard filterCard = new FilterPermanentCard("permanent card with mana value " + permanent.getPower().getValue() + " or less");
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, permanent.getPower().getValue() + 1));
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)filterCard);
        player.choose(Outcome.PutCardInPlay, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

