/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MirenTheMoaningWellEffect
extends OneShotEffect {
    MirenTheMoaningWellEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the sacrificed creature's toughness";
    }

    private MirenTheMoaningWellEffect(MirenTheMoaningWellEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirenTheMoaningWellEffect copy() {
        return new MirenTheMoaningWellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Cost cost : source.getCosts()) {
                int amount;
                if (!(cost instanceof SacrificeTargetCost) || (amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue()) <= 0) continue;
                controller.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }
}

