/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class MirkwoodBatsTriggeredAbility
extends TriggeredAbilityImpl {
    MirkwoodBatsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeOpponentsEffect(1));
        this.setTriggerPhrase("Whenever you create or sacrifice a token, ");
    }

    private MirkwoodBatsTriggeredAbility(MirkwoodBatsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MirkwoodBatsTriggeredAbility copy() {
        return new MirkwoodBatsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATED_TOKEN || event.getType() == GameEvent.EventType.SACRIFICED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case CREATED_TOKEN: {
                return true;
            }
            case SACRIFICED_PERMANENT: {
                Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
                return permanent instanceof PermanentToken;
            }
        }
        return false;
    }
}

