/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MirranSafehouseEffect
extends ContinuousEffectImpl {
    MirranSafehouseEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "As long as {this} is on the battlefield, it has all activated abilities of all land cards in all graveyards";
        this.dependendToTypes.add(DependencyType.AddingAbility);
    }

    private MirranSafehouseEffect(MirranSafehouseEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        Set abilities = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(graveyard -> graveyard.getCards((FilterCard)StaticFilters.FILTER_CARD_LAND, game)).flatMap(Collection::stream).map(card -> card.getAbilities(game)).flatMap(Collection::stream).filter(Ability::isActivatedAbility).collect(Collectors.toSet());
        for (Ability ability : abilities) {
            permanent.addAbility(ability, source.getSourceId(), game, true);
        }
        return true;
    }

    public MirranSafehouseEffect copy() {
        return new MirranSafehouseEffect(this);
    }
}

