/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MirrorMatchEffect
extends OneShotEffect {
    MirrorMatchEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each creature attacking you or a planeswalker you control, create a token that's a copy of that creature blocking that creature. Exile those tokens at end of combat";
    }

    private MirrorMatchEffect(MirrorMatchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorMatchEffect copy() {
        return new MirrorMatchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID attackerId : game.getCombat().getAttackers()) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null || !source.isControlledBy(game.getCombat().getDefendingPlayerId(attackerId, game))) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(attacker, game));
                effect.apply(game, source);
                CombatGroup group = game.getCombat().findGroup(attacker.getId());
                if (group == null) continue;
                for (Permanent addedToken : effect.getAddedPermanents()) {
                    if (!addedToken.isCreature(game)) continue;
                    group.addBlockerToGroup(addedToken.getId(), attackerId, game);
                }
                ExileTargetEffect exileEffect = new ExileTargetEffect("Exile those tokens at end of combat");
                exileEffect.setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)exileEffect), source);
            }
            return true;
        }
        return false;
    }
}

