/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.abilities.keyword.BackupAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MirrorShieldHopliteTriggeredAbility
extends TriggeredAbilityImpl {
    MirrorShieldHopliteTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyStackObjectEffect());
        this.setTriggerPhrase("Whenever a creature you control becomes the target of a backup ability, ");
        this.setTriggersLimitEachTurn(1);
    }

    private MirrorShieldHopliteTriggeredAbility(MirrorShieldHopliteTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MirrorShieldHopliteTriggeredAbility copy() {
        return new MirrorShieldHopliteTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject sourceObject = game.getStack().getStackObject(event.getSourceId());
        if (sourceObject == null || !(sourceObject.getStackAbility() instanceof BackupAbility)) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
        return true;
    }
}

