/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MirrorStyleMasterEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    MirrorStyleMasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each attacking modified creature you control, create a tapped and attacking token that's a copy of that creature. Exile those tokens at end of combat";
    }

    private MirrorStyleMasterEffect(MirrorStyleMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorStyleMasterEffect copy() {
        return new MirrorStyleMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList permanents = new ArrayList();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true);
            effect.setSavedPermanent(permanent);
            effect.apply(game, source);
            permanents.addAll(effect.getAddedPermanents());
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new ExileTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(permanents, game)).setText("exile those tokens")), source);
        return true;
    }

    static {
        filter.add((Predicate)AttackingPredicate.instance);
        filter.add((Predicate)ModifiedPredicate.instance);
    }
}

