/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MirrorWeaveEffect
extends OneShotEffect {
    MirrorWeaveEffect() {
        super(Outcome.Copy);
        this.staticText = "Each other creature becomes a copy of target nonlegendary creature until end of turn";
    }

    private MirrorWeaveEffect(MirrorWeaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorWeaveEffect copy() {
        return new MirrorWeaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        if (controller != null) {
            Permanent copyFromCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (copyFromCreature != null) {
                filter.add(Predicates.not((Predicate)new PermanentIdPredicate(copyFromCreature.getId())));
                for (Permanent copyToCreature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                    if (copyToCreature == null) continue;
                    game.copyPermanent(Duration.EndOfTurn, copyFromCreature, copyToCreature.getId(), source, (CopyApplier)new EmptyCopyApplier());
                }
            }
            return true;
        }
        return false;
    }
}

