/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MisfortunesGainEffect
extends OneShotEffect {
    MisfortunesGainEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. Its owner gains 4 life";
    }

    private MisfortunesGainEffect(MisfortunesGainEffect effect) {
        super((OneShotEffect)effect);
    }

    public MisfortunesGainEffect copy() {
        return new MisfortunesGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && target != null) {
            target.destroy(source, game, false);
            Player owner = game.getPlayer(target.getOwnerId());
            if (owner != null) {
                owner.gainLife(4, game, source);
            }
            return true;
        }
        return false;
    }
}

