/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.UnearthAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class MishraTamerOfMakFawaEffect
extends ContinuousEffectImpl {
    MishraTamerOfMakFawaEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "each artifact card in your graveyard has unearth {1}{B}{R}";
    }

    private MishraTamerOfMakFawaEffect(MishraTamerOfMakFawaEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MishraTamerOfMakFawaEffect copy() {
        return new MishraTamerOfMakFawaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game)) {
            game.getState().addOtherAbility(card, (Ability)new UnearthAbility((Cost)new ManaCostsImpl("{1}{B}{R}")));
        }
        return true;
    }
}

