/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MistmoonGriffinEffect
extends OneShotEffect {
    MistmoonGriffinEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return the top creature card of your graveyard to the battlefield";
    }

    private MistmoonGriffinEffect(MistmoonGriffinEffect effect) {
        super((OneShotEffect)effect);
    }

    public MistmoonGriffinEffect copy() {
        return new MistmoonGriffinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card lastCreatureCard = null;
            for (Card card : controller.getGraveyard().getCards(game)) {
                if (!card.isCreature(game)) continue;
                lastCreatureCard = card;
            }
            if (lastCreatureCard != null) {
                return controller.moveCards(lastCreatureCard, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

