/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetArtifactPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MizziumTransreliquatCopyAndGainAbilityEffect
extends OneShotEffect {
    MizziumTransreliquatCopyAndGainAbilityEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of target artifact, except it has this ability";
    }

    private MizziumTransreliquatCopyAndGainAbilityEffect(MizziumTransreliquatCopyAndGainAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public MizziumTransreliquatCopyAndGainAbilityEffect copy() {
        return new MizziumTransreliquatCopyAndGainAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            Permanent newPermanent = game.copyPermanent(copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new MizziumTransreliquatCopyAndGainAbilityEffect(), (Cost)new ManaCostsImpl("{1}{U}{R}"));
            ability.addTarget((Target)new TargetArtifactPermanent());
            newPermanent.addAbility((Ability)ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

