/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MnemonicNexusEffect
extends OneShotEffect {
    MnemonicNexusEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player shuffles their graveyard into their library";
    }

    private MnemonicNexusEffect(MnemonicNexusEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (sourcePlayer == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.shuffleCardsToLibrary((Cards)player.getGraveyard(), game, source);
        }
        return true;
    }

    public MnemonicNexusEffect copy() {
        return new MnemonicNexusEffect(this);
    }
}

