/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MobVerdictVote;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MobVerdictEffect
extends OneShotEffect {
    MobVerdictEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for another player, then those votes are revealed. For each vote an opponent received, {this} deals 2 damage to that player and each creature that player controls. For each vote you received, draw a card";
    }

    private MobVerdictEffect(MobVerdictEffect effect) {
        super((OneShotEffect)effect);
    }

    public MobVerdictEffect copy() {
        return new MobVerdictEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MobVerdictVote vote = new MobVerdictVote();
        vote.doVotes(source, game);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            int count;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || (count = vote.getVoteCount(opponent)) < 1) continue;
            opponent.damage(2 * count, source, game);
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, opponentId, source, game)) {
                permanent.damage(2 * count, source, game);
            }
        }
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(vote.getVoteCount(player), source, game));
        return true;
    }
}

