/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class MobilizerMechTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.VEHICLE, "up to one other Vehicle you control");

    MobilizerMechTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}));
        this.addTarget((Target)new TargetPermanent(0, 1, filter));
    }

    private MobilizerMechTriggeredAbility(MobilizerMechTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MobilizerMechTriggeredAbility copy() {
        return new MobilizerMechTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.VEHICLE_CREWED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId());
    }

    public String getRule() {
        return "Whenever {this} becomes crewed, up to one other target Vehicle you control becomes an artifact creature until end of turn.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

