/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.MoogleToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetDiscard;

class MogMoogleWarriorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.MOOGLE);

    MogMoogleWarriorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may discard a card. Each player who discarded a card this way draws a card. If a creature card was discarded this way, you create a 1/2 white Moogle creature token with lifelink. Then if a noncreature card was discarded this way, put a +1/+1 counter on each Moogle you control";
    }

    private MogMoogleWarriorEffect(MogMoogleWarriorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MogMoogleWarriorEffect copy() {
        return new MogMoogleWarriorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        HashMap<UUID, Card> map = new HashMap<UUID, Card>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetDiscard target = new TargetDiscard(0, 1, StaticFilters.FILTER_CARD, playerId);
            player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
            card = game.getCard(target.getFirstTarget());
            if (card == null) continue;
            map.put(playerId, card);
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            card = map.getOrDefault(playerId, null);
            if (player == null || card == null || !player.discard(card, false, source, game)) continue;
            cards.add(card);
            player.drawCards(1, source, game);
        }
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) > 0) {
            new MoogleToken().putOntoBattlefield(1, game, source);
        }
        if (cards.count(StaticFilters.FILTER_CARD_NON_CREATURE, game) < 1) {
            return true;
        }
        game.processAction();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return true;
    }
}

