/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class MogisGodOfSlaughterEffect
extends OneShotEffect {
    MogisGodOfSlaughterEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to that player unless they sacrifice a creature of their choice";
    }

    private MogisGodOfSlaughterEffect(MogisGodOfSlaughterEffect effect) {
        super((OneShotEffect)effect);
    }

    public MogisGodOfSlaughterEffect copy() {
        return new MogisGodOfSlaughterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, game.getActivePlayerId(), game) == 0) {
            return player.damage(2, source.getSourceId(), source, game) > 0;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (target.canChoose(player.getId(), source, game) && player.chooseUse(Outcome.Detriment, "Sacrifice a creature to prevent 2 damage?", source, game) && player.choose(Outcome.Sacrifice, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && permanent.sacrifice(source, game)) {
            return true;
        }
        return player.damage(2, source.getSourceId(), source, game) > 0;
    }
}

