/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.DescendCondition;
import mage.abilities.condition.common.DescendedThisTurnCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreatureOrPlaneswalker;
import mage.watchers.Watcher;
import mage.watchers.common.DescendedWatcher;

public final class MoltenCollapse
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("noncreature, nonland permanent with mana value 1 or less");

    public MoltenCollapse(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{B}{R}");
        this.getSpellAbility().getModes().setMoreCondition(2, (Condition)DescendedThisTurnCondition.instance);
        this.getSpellAbility().getModes().setChooseText("Choose one. If you descended this turn, you may choose both instead.");
        this.getSpellAbility().addHint(DescendCondition.getHint());
        this.getSpellAbility().addWatcher((Watcher)new DescendedWatcher());
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetCreatureOrPlaneswalker());
        this.getSpellAbility().addMode(new Mode((Effect)new DestroyTargetEffect()).addTarget((Target)new TargetPermanent(filter)));
    }

    private MoltenCollapse(MoltenCollapse card) {
        super((CardImpl)card);
    }

    public MoltenCollapse copy() {
        return new MoltenCollapse(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 1));
    }
}

