/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.MetalcraftCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MoltenPsycheWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MoltenPsycheEffect
extends OneShotEffect {
    MoltenPsycheEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player shuffles the cards from their hand into their library, then draws that many cards.<br><i>Metalcraft</i> &mdash; If you control three or more artifacts, {this} deals damage to each opponent equal to the number of cards that player has drawn this turn.";
    }

    private MoltenPsycheEffect(MoltenPsycheEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            LinkedHashMap<UUID, Integer> cardsToDraw = new LinkedHashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                int cardsInHand = player.getHand().size();
                if (cardsInHand > 0) {
                    cardsToDraw.put(playerId, cardsInHand);
                }
                player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
                player.shuffleLibrary(source, game);
            }
            game.processAction();
            for (UUID playerId : cardsToDraw.keySet()) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                player.drawCards(((Integer)cardsToDraw.get(playerId)).intValue(), source, game);
            }
            if (MetalcraftCondition.instance.apply(game, source)) {
                MoltenPsycheWatcher watcher = (MoltenPsycheWatcher)game.getState().getWatcher(MoltenPsycheWatcher.class);
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player player2;
                    if (!game.isOpponent(controller, playerId) || (player2 = game.getPlayer(playerId)) == null || watcher == null) continue;
                    player2.damage(watcher.getDraws(playerId), source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public MoltenPsycheEffect copy() {
        return new MoltenPsycheEffect(this);
    }
}

