/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MoltenRainEffect
extends OneShotEffect {
    MoltenRainEffect() {
        super(Outcome.Damage);
        this.staticText = "If that land was nonbasic, {this} deals 2 damage to the land's controller";
    }

    private MoltenRainEffect(MoltenRainEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoltenRainEffect copy() {
        return new MoltenRainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (permanent != null && !permanent.isBasic(game) && (player = game.getPlayer(permanent.getControllerId())) != null) {
            player.damage(2, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

