/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MomentumBreakerEffect
extends OneShotEffect {
    MomentumBreakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent sacrifices a creature or Vehicle of their choice. Each opponent who can't discards a card.";
    }

    private MomentumBreakerEffect(MomentumBreakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MomentumBreakerEffect copy() {
        return new MomentumBreakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getOpponents(source.getControllerId()).forEach(opponent -> {
            Player player = game.getPlayer(opponent);
            if (player != null) {
                FilterPermanent filter = new FilterPermanent("creature or Vehicle");
                filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
                filter.add((Predicate)new ControllerIdPredicate(opponent));
                SacrificeEffect effect = new SacrificeEffect(filter, 1, null);
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
                if (!effect.apply(game, source)) {
                    player.discard(1, false, false, source, game);
                }
            }
        });
        return true;
    }
}

