/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class MomoFriendlyFlierWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    MomoFriendlyFlierWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.isCreature(game) && !spell.hasSubtype(SubType.LEMUR, game) && spell.getAbilities(game).containsClass(FlyingAbility.class)) {
            this.set.add(spell.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((MomoFriendlyFlierWatcher)game.getState().getWatcher(MomoFriendlyFlierWatcher.class)).set.contains(source.getControllerId());
    }
}

