/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class MoonholdEffect
extends ContinuousRuleModifyingEffectImpl {
    MoonholdEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
    }

    private MoonholdEffect(MoonholdEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MoonholdEffect copy() {
        return new MoonholdEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "you can't play land cards this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getFirstTarget());
    }
}

