/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class MoonholdEffect2
extends ContinuousRuleModifyingEffectImpl {
    public MoonholdEffect2() {
        super(Duration.EndOfTurn, Outcome.Detriment);
    }

    private MoonholdEffect2(MoonholdEffect2 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MoonholdEffect2 copy() {
        return new MoonholdEffect2(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't play creature cards this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        return event.getPlayerId().equals(source.getFirstTarget()) && (card = game.getCard(event.getSourceId())) != null && card.isCreature(game);
    }
}

