/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.util.functions.CopyTokenFunction;
import mage.util.functions.EmptyCopyApplier;
import mage.watchers.common.CreatedTokenWatcher;

class MoonlitMeditationEffect
extends ReplacementEffectImpl {
    MoonlitMeditationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false);
        this.staticText = "the first time you would create one or more tokens each turn, you may instead create that many tokens that are copies of enchanted permanent";
    }

    private MoonlitMeditationEffect(MoonlitMeditationEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && !CreatedTokenWatcher.checkPlayer((UUID)source.getControllerId(), (Game)game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        block3: {
            block2: {
                permanent = Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
                if (permanent == null) break block2;
                if (Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> player.chooseUse(Outcome.Benefit, "Replace the tokens with copies of " + permanent.getLogName() + '?', source, game)).isPresent()) break block3;
            }
            return false;
        }
        CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
        int amount = tokenEvent.getAmount();
        tokenEvent.getTokens().clear();
        tokenEvent.getTokens().put(MoonlitMeditationEffect.copyPermanentToToken(permanent, game, source), amount);
        return false;
    }

    public MoonlitMeditationEffect copy() {
        return new MoonlitMeditationEffect(this);
    }

    private static Token copyPermanentToToken(Permanent permanent, Game game, Ability source) {
        EmptyCopyApplier applier = new EmptyCopyApplier();
        Permanent copyFromPermanent = permanent;
        for (ContinuousEffect effect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
            MageObject object;
            CopyEffect copyEffect;
            if (!(effect instanceof CopyEffect) || !(copyEffect = (CopyEffect)effect).getSourceId().equals(permanent.getId()) || !((object = ((CopyEffect)effect).getTarget()) instanceof Permanent)) continue;
            copyFromPermanent = (Permanent)object;
            if (copyEffect.getApplier() == null) continue;
            applier = copyEffect.getApplier();
        }
        Token token = CopyTokenFunction.createTokenCopy((Card)copyFromPermanent, (Game)game);
        applier.apply(game, (MageObject)token, source, permanent.getId());
        return token;
    }
}

