/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MoonmistEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("humans");

    public MoonmistEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "Transform all Humans";
    }

    private MoonmistEffect(MoonmistEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            permanent.transform(source, game);
        }
        return true;
    }

    public MoonmistEffect copy() {
        return new MoonmistEffect(this);
    }

    static {
        filter.add((Predicate)SubType.HUMAN.getPredicate());
    }
}

