/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MoralityShiftEffect
extends OneShotEffect {
    MoralityShiftEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Exchange your graveyard and library. Then shuffle your library.";
    }

    private MoralityShiftEffect(MoralityShiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoralityShiftEffect copy() {
        return new MoralityShiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet copyLibrary = new LinkedHashSet(controller.getLibrary().getCards(game));
        LinkedHashSet copyGraveyard = new LinkedHashSet(controller.getGraveyard().getCards(game));
        controller.moveCards(copyGraveyard, Zone.LIBRARY, source, game);
        controller.moveCards(copyLibrary, Zone.GRAVEYARD, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

