/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MoraugFuryOfAkoumDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.TurnMod;

class MoraugFuryOfAkoumCombatEffect
extends OneShotEffect {
    MoraugFuryOfAkoumCombatEffect() {
        super(Outcome.Benefit);
        this.staticText = "there's an additional combat phase after this phase. At the beginning of that combat, untap all creatures you control";
    }

    private MoraugFuryOfAkoumCombatEffect(MoraugFuryOfAkoumCombatEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoraugFuryOfAkoumCombatEffect copy() {
        return new MoraugFuryOfAkoumCombatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TurnPhase turnPhase = game.getTurnPhaseType();
        for (TurnMod turnMod : game.getState().getTurnMods()) {
            if (!"moraug".equals(turnMod.getTag()) || !turnMod.getPlayerId().equals(source.getControllerId()) || turnMod.getAfterPhase() != turnPhase) continue;
            turnPhase = TurnPhase.COMBAT;
            turnMod.withTag("moraugIgnore");
            break;
        }
        TurnMod combat = new TurnMod(source.getControllerId()).withExtraPhase(TurnPhase.COMBAT, turnPhase).withTag("moraug");
        game.getState().getTurnMods().add(combat);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new MoraugFuryOfAkoumDelayedTriggeredAbility(combat.getId()), source);
        return true;
    }
}

