/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MordorOnTheMarchEffect
extends OneShotEffect {
    MordorOnTheMarchEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile a creature card from your graveyard. Create a token that's a copy of it. It gains haste until end of turn. Exile it at the beginning of the next end step";
    }

    private MordorOnTheMarchEffect(MordorOnTheMarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MordorOnTheMarchEffect copy() {
        return new MordorOnTheMarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return true;
        }
        controller.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1));
            controller.moveCards(card, Zone.EXILED, source, game);
            effect.apply(game, source);
            effect.getAddedPermanents().stream().forEach(permanent -> {
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.UntilYourNextTurn);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            });
            ExileTargetEffect exileEffect = new ExileTargetEffect();
            exileEffect.setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

